/* 
	Adapted from mote - by Tom Visser - http://www.strand-dev.com/forums/viewtopic.php?f=34&t=1694

 	This file was created by Tim Moore. It may be used and adapted freely. 
	If you modify it into a creation of your own please credit it with the text: 
	Adapted from mote - by Tom Visser

    (snip) This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

*/
/*
remote states
0: init
1: channels - enter channel number
2: channels - enter channel level
3: looks - enter look number
4: looks - enter look level
*/

/* remote variables */
var remote_state = 0;		// holds current state of remote
var ch_channels = '';		// holds current channel(s) selection
var ch_level = '';			// holds current channel(s) level
var lk_num = '';			// holds current look number
var lk_level = '';			// holds current look level
var display = '&nbsp;';		// holds display string
var clear_toggle = false;	// if true reset remote after successful execution and number pressed

$(function() /* html loaded - set event handlers and reset remote */
{
	$(".number").click(function(){	// if number pressed get number held in ref attribute
		num = $(this).attr("ref");
		btn_enter_number(num);
		return false;
	});
	$(".enter").click(function(){ 	btn_enter(); 	return false; });
	$(".on").click(function(){ 		btn_on(); 		return false; });
	$(".off").click(function(){ 	btn_off(); 		return false; });
	$(".thru").click(function(){ 	btn_thru(); 	return false; });
	$(".minus").click(function(){ 	btn_minus(); 	return false; });
	$(".plus").click(function(){ 	btn_plus(); 	return false; });
	$(".rel").click(function(){ 	btn_rel(); 		return false; });
	$(".look").click(function(){ 	btn_look(); 	return false; });
	$(".at").click(function(){ 		btn_at(); 		return false; });
	$(".clr").click(function(){ 	btn_clr(); 		return false; });
	$(".rem").click(function(){ 	btn_rem(); 		return false; });
	reset_remote();
});

/* common functions */
function send_command(command){ // send command to lighting desk
	//$("#debug").html(command); // shows debugging info
	command = ip + 'script.mq?' + command; 
	$.get(command, function(data){});
}
function set_look(lk_num, lk_level){ // build look command and pass to send_command
	send_command("HC.LookFade('"+looks_page+"', '"+lk_num + "', '" + lk_level + "','0')");	
}
function set_channels(channels, val, time){ // build channel command and pass to send_command
	atint = parseInt(val)/100*255;
	sendlvl = Math.round(atint) + ""
	channels = channels.replace("+","%2B");
	send_command("HC.Select('"+channels+"')" + "HC.SetLevel(HC.GetCurrentSelectionSet('%2B'), '" + sendlvl + "','" + time*1000 + "')");
}
function update_display(){ // update remote display
	display=display.replace(/%2D/g, " - ");
	display=display.replace(/%2B/g, " + ");
	display=display.replace(/%2F/g, " Thru ");  
	if(display.length == 0){display='&nbsp;';}
	$("#output").html(display);
}
function reset_remote(){ // reset remote
	ch_channels = '';
	ch_level = '';
	ch_time = 0;
	lk_num = '';
	lk_level = '';
	lk_time = 0;
	remote_state = 1;
	clear_toggle = false;
	display = 'Strand Palette';
	update_display();
	send_command("HC.Deselect(HC.GetCurrentSelectionSet('%2B'))");
}

/* button events */
function btn_enter_number(num){ // numeric buttons
	
	 // if pressed enter or rem dim then clear for new entry
	if (clear_toggle == true){ reset_remote(); }
	
	switch (remote_state)
	{
		case 1: // entering a channel
			ch_channels = ch_channels+num;
			display = ch_channels;
		break;
		
		case 2: // entering a level
			ch_level = ch_level+num;
			display = ch_channels+'@'+ch_level;
		break;
		
		case 3: // entering a look
			lk_num = lk_num+num;
			display = 'Look ' + lk_num;
		break;
		
		case 4: // entering a look
			lk_level = lk_level+num;
			display = 'Look ' + lk_num + '@' + lk_level;
		break;
	}
	update_display();
}

function btn_enter(){ // enter button
	switch (remote_state)
	{
		case 1: case 2:// entering a channel
			if (ch_level == ''){ch_level = ch_default_level;}
			set_channels(ch_channels, ch_level, 0);
			clear_toggle = 1;
			display = display + ' *';
			update_display();
		break;
		
		case 3: case 4: // entering a look
			if (lk_level == ''){lk_level = look_default_level;}
			set_look(lk_num, lk_level, 0);
			clear_toggle = 1;
			display = display + ' *';
		break;
	}
	clear_toggle = true;
	update_display();
}

function btn_on(){ // on button
	switch (remote_state)
	{
		case 1: case 2:// entering a channel
			set_channels(ch_channels, 100, 0);
			clear_toggle = 1;
			display = display + ' *';
			update_display();
		break;
		
		case 3: case 4: // entering a look
			set_look(lk_num, 100, 0);
			clear_toggle = 1;
			display = display + ' *';
			update_display();
		break;
		
	}
	clear_toggle = true;
	update_display();
}

function btn_off(){ // off button
	switch (remote_state)
	{
		case 1: case 2:// entering a channel
			set_channels(ch_channels, 0, 0);
			clear_toggle = 1;
			display = display + ' *';
			update_display();
		break;
		
		case 3: case 4: // entering a look
			set_look(lk_num, 0, 0);
			clear_toggle = 1;
			display = display + ' *';
			update_display();
		break;
		
	}
	update_display();
}

function btn_thru(){ // thru button							  
	ch_channels=ch_channels + "%2F";
	display = ch_channels;
	update_display();
}
function btn_minus(){ // - button							  
	ch_channels=ch_channels + "%2D";
	display = ch_channels;
	update_display();
}
function btn_plus(){ // + button							  
	ch_channels=ch_channels + "%2B";
	display = ch_channels;
	update_display();
}
function btn_rel(){ // release button	
	send_command(("HC.ReleaseAll()"));	
	reset_remote();
}

function btn_look(){ // look button	
	reset_remote();
	display = 'Look ';
	update_display();
	remote_state = 3;
	clear_toggle = false;
}

function btn_at(){ // @ button
	switch (remote_state)
	{
		case 1: // entering a channel number
			remote_state = 2;
			display = ch_channels + ' @ ';
		break;
		
		case 3: // entering a look
			remote_state = 4;
			display = 'Look ' + lk_num + ' @ ';
		break;
	}
	update_display();
}
		
function btn_clr(){ // clear - go back a character
	switch (remote_state)
	{
		case 1: // entering a channel
			ch_channels = ch_channels.substr(0, ch_channels.length-1);
			display = ch_channels;
		break;
		
		case 2: // entering a level
			ch_level = ch_level.substr(0, ch_level.length-1);
			display = ch_channels+'@'+ch_level;
		break;
		
		case 3: // entering a look
			lk_num = lk_num.substr(0, lk_num.length-1);
			display = 'Look ' + lk_num;
		break;
		
		case 4: // entering a look
			lk_level = lk_level.substr(0, lk_level.length-1);
			display = 'Look ' + lk_num + '@' + lk_level;
		break;
	}
	update_display();		
}

function btn_rem(){ // rem dim
	send_command("HC.ReleaseAll()") + ("HC.Select('"+ch_channels+"')" + "HC.RemDim(HC.GetCurrentSelectionSet('%2B'))");
	clear_toggle = true;
	display = display + ' *';
	update_display();	
}
